<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Superio
 * @since Superio 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Corporation",
  "name": "Tạo dấu ấn trong ngành truyền thông với VieclamTruyenThong.com - Hàng ngàn việc làm chất lượng và 95% ứng viên hài lòng!",
  "alternateName": "VieclamTruyenThong",
  "url": "http://vieclamtruyenthong.com/",
  "logo": "https://vieclamtruyenthong.com/wp-content/uploads/elementor/thumbs/vieclam-truyen-thong-qkjvs8b8jalj33z6cho3jif8gcndw3fb322hv1wzdg.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "0855 301 305",
    "contactType": "technical support",
    "contactOption": "TollFree",
    "areaServed": "VN",
    "availableLanguage": "Vietnamese"
  },
  "sameAs": [
    "https://sites.google.com/view/vieclamtruyenthong/",
    "https://www.youtube.com/channel/UCQGos51f0_fvBcUaPvYgISQ/about",
    "https://twitter.com/vltruyenthong",
    "https://www.reddit.com/user/vieclamtruyenthong/",
    "https://www.linkedin.com/in/vieclamtruyenthong/",
    "https://vieclamtruyenthong.blogspot.com/",
    "https://www.pinterest.com/vieclamtruyenthong/",
    "https://vieclamtruyenthong.tumblr.com/"
  ]
}
</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "Tạo dấu ấn trong ngành truyền thông với VieclamTruyenThong.com - Hàng ngàn việc làm chất lượng và 95% ứng viên hài lòng!",
  "image": "https://vieclamtruyenthong.com/wp-content/uploads/elementor/thumbs/vieclam-truyen-thong-qkjvs8b8jalj33z6cho3jif8gcndw3fb322hv1wzdg.png",
  "@id": "http://vieclamtruyenthong.com/",
  "url": "http://vieclamtruyenthong.com/",
  "telephone": "0855 301 305",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "574 Đường Sinco, An Lạc A, Bình Tân, Thành phố Hồ Chí Minh, Việt Nam",
    "addressLocality": "Thành phố Hồ Chí Minh",
    "postalCode": "70000",
    "addressCountry": "VN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 10.7323883,
    "longitude": 106.6089571
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://sites.google.com/view/vieclamtruyenthong/",
    "https://twitter.com/vltruyenthong",
    "https://www.youtube.com/channel/UCQGos51f0_fvBcUaPvYgISQ/about",
    "https://www.reddit.com/user/vieclamtruyenthong/",
    "https://www.linkedin.com/in/vieclamtruyenthong/",
    "https://vieclamtruyenthong.blogspot.com/",
    "https://www.pinterest.com/vieclamtruyenthong/",
    "https://vieclamtruyenthong.tumblr.com/"
  ] 
}
</script>
	<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Person",
  "name": "Nguyễn Gia Huy",
  "url": "https://vieclamtruyenthong.com/author/admin/",
  "image": "https://blogreview.com.vn/wp-content/uploads/2023/08/chup-anh-profile-ca-nhan-o-da-nang-1.jpg",
  "sameAs": [
    "https://sites.google.com/view/ceogiahuy",
    "https://www.youtube.com/channel/UC2Fwjlx0OLguwrpykaDorLQ",
    "https://www.reddit.com/user/ceogiahuy/",
    "https://twitter.com/ceogiahuy",
    "https://www.linkedin.com/in/ceogiahuy/",
    "https://ceogiahuy.blogspot.com",
    "https://www.pinterest.com/ceogiahuy/",
    "https://ceogiahuy.tumblr.com/"
  ],
  "jobTitle": "CEO",
  "worksFor": {
    "@type": "Organization",
    "name": "vieclamtruyenthong.com"
  }  
}
</script>
	
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-JH0ZEWV53P"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-JH0ZEWV53P');
</script>
	<meta name='dmca-site-verification' content='RlpzeEpoUkcrS01hK1VNWXNsT1NCQisxNGxOTkRJSjQzem96WERYVWVhcz01' />
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="//gmpg.org/xfn/11">
	
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php if ( superio_get_config('preload', true) ) {
	$preload_icon = superio_get_config('media-preload-icon');
	$styles = array();
	if ( !empty($preload_icon['id']) ) {
		$img = wp_get_attachment_image_src($preload_icon['id'], 'full');
		if ( !empty($img[0]) ) {
			$styles[] = 'background-image: url(\''.$img[0].'\');';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'width: '.$img[1].'px;';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'height: '.$img[2].'px;';
		}
    }
    $style_attr = '';
    if ( !empty($styles) ) {
    	$style_attr = 'style="'.implode(' ', $styles).'"';
    }
?>
	<div class="apus-page-loading">
        <div class="apus-loader-inner" <?php echo trim($style_attr); ?>></div>
    </div>
<?php } ?>
<div id="wrapper-container" class="wrapper-container">
	<?php
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    }
    if ( superio_get_config('separate_header_mobile', true) ) {
	    get_template_part( 'headers/mobile/offcanvas-menu' );
		get_template_part( 'headers/mobile/header-mobile' );
	}
	?>

	<?php
		$header = apply_filters( 'superio_get_header_layout', superio_get_config('header_type') );
		if ( !empty($header) ) {
			superio_display_header_builder($header);
		} else {
			get_template_part( 'headers/default' );
		}
	?>
	<div id="apus-main-content">